/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime;

import filenet.vw.api.VWException;
import filenet.vw.api.VWFieldDefinition;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWStepOccurrenceHistory;
import filenet.vw.api.VWStepWorkObjectHistory;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataField;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStep;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrenceHistory;
import filenet.vw.toolkit.runtime.VWTrkTestDataField;
import filenet.vw.toolkit.runtime.VWTrkWork;
import filenet.vw.toolkit.runtime.VWTrkWorkObject;
import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.util.Date;
import java.util.Vector;
import javax.swing.ImageIcon;

public final class VWTrkStepOccurrence {
    private VWTrkStep m_step = null;
    private int m_stepId = -1;
    private int m_occurrenceId = -1;
    private int m_index = -1;
    private VWTrkStepOccurrenceHistory m_stepOccurrenceHistory = null;
    private VWTrkWorkObject m_rendezvousWO = null;
    private Vector m_work = new Vector();
    private Vector m_dataFieldObjects = new Vector();
    private Vector m_attachments = new Vector();
    private Vector m_workflowGroups = new Vector();
    private boolean m_bUpdateWorkHistory = true;
    private boolean m_bUpdatingWorkHistory = false;

    public VWTrkStepOccurrence(VWTrkStep step, VWStepOccurrenceHistory stepOccurrenceHistory, int stepId, int index) {
        this.m_step = step;
        this.m_stepId = stepId;
        this.m_index = index;
        this.m_stepOccurrenceHistory = new VWTrkStepOccurrenceHistory(stepOccurrenceHistory);
        this.m_bUpdateWorkHistory = true;
        if (stepOccurrenceHistory != null) {
            this.m_occurrenceId = stepOccurrenceHistory.getOccurrenceId();
        }
    }

    public VWTrkStepOccurrence(VWTrkStep step, VWTrkStepOccurrenceHistory stepOccurrenceHistory, int stepId, int index) {
        this.m_step = step;
        this.m_stepId = stepId;
        this.m_index = index;
        this.m_stepOccurrenceHistory = stepOccurrenceHistory;
        this.m_bUpdateWorkHistory = true;
        if (stepOccurrenceHistory != null) {
            this.m_occurrenceId = stepOccurrenceHistory.getOccurrenceId();
        }
    }

    public VWTrkDataModel getDataModel() {
        if (this.m_step != null) {
            return this.m_step.getDataModel();
        }
        return null;
    }

    public VWTrkStep getStep() {
        return this.m_step;
    }

    public void updateStepOccurrenceHistory(VWStepOccurrenceHistory stepOccurrenceHistory) {
        if (this.m_stepOccurrenceHistory != null) {
            this.m_stepOccurrenceHistory.removeReferences();
        }
        this.m_stepOccurrenceHistory = new VWTrkStepOccurrenceHistory(stepOccurrenceHistory);
        this.m_bUpdateWorkHistory = true;
    }

    public void updateStepOccurrenceHistory(VWTrkStepOccurrenceHistory stepOccurrenceHistory) {
        if (this.m_stepOccurrenceHistory != null) {
            this.m_stepOccurrenceHistory.removeReferences();
        }
        this.m_stepOccurrenceHistory = stepOccurrenceHistory;
        this.m_bUpdateWorkHistory = true;
    }

    public VWTrkStepOccurrenceHistory getStepOccurrenceHistory() {
        return this.m_stepOccurrenceHistory;
    }

    private void updateWorkHistory() {
        if (this.m_bUpdatingWorkHistory) {
            return;
        }
        this.m_bUpdatingWorkHistory = true;
        try {
            VWStepOccurrenceHistory stepOccurrenceHistory;
            if (this.m_bUpdateWorkHistory && this.m_stepOccurrenceHistory != null && (stepOccurrenceHistory = this.m_stepOccurrenceHistory.getVWStepOccurrenceHistory()) != null) {
                stepOccurrenceHistory.resetFetch();
                try {
                    VWStepWorkObjectHistory workHistory = null;
                    while (stepOccurrenceHistory.hasNext()) {
                        workHistory = stepOccurrenceHistory.next();
                        VWTrkWork work = this.findWork(workHistory.getWorkObjectNumber());
                        if (work != null) {
                            work.setWorkHistory(workHistory);
                            continue;
                        }
                        work = new VWTrkWork(this.m_stepId, this, workHistory);
                        this.m_work.addElement(work);
                    }
                    this.m_bUpdateWorkHistory = false;
                }
                catch (VWException ex) {
                    VWDebug.logException(ex);
                    this.m_bUpdatingWorkHistory = false;
                }
            }
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
        }
        this.m_bUpdatingWorkHistory = false;
    }

    private VWTrkWork findWork(String wobNumber) {
        if (this.m_work == null || this.m_work.size() == 0) {
            return null;
        }
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (VWStringUtils.compare(wobNumber, work.getWorkObjectNumber()) != 0) continue;
            return work;
        }
        return null;
    }

    public void addWorkObject(VWTrkWorkObject workObject) {
        if (workObject == null) {
            return;
        }
        this.updateWorkHistory();
        VWTrkWork work = this.findWork(workObject.getWorkObjectNumber());
        if (work != null) {
            work.addWorkObject(workObject);
        } else {
            work = new VWTrkWork(this.m_stepId, this, workObject);
            this.m_work.addElement(work);
        }
    }

    public Vector getParticipantWorkObjectCollection() {
        Vector<VWTrkWorkObject> collection = new Vector<VWTrkWorkObject>();
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            VWTrkWorkObject workObject = work.getWorkObject();
            if (workObject == null) continue;
            collection.addElement(workObject);
        }
        return collection;
    }

    public Vector getWorkObjectCollection() {
        Vector collection = this.getParticipantWorkObjectCollection();
        if (this.m_rendezvousWO != null) {
            collection.addElement(this.m_rendezvousWO);
        }
        return collection;
    }

    public Vector getWorkCollection() {
        this.updateWorkHistory();
        return this.m_work;
    }

    public Vector getParticipantCollection() {
        this.updateWorkHistory();
        Vector vector = new Vector();
        if (this.m_work == null && this.m_work.size() == 0) {
            return vector;
        }
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            Vector participants = work.getParticipants();
            if (participants == null || participants.size() == 0) continue;
            for (int j = 0; j < participants.size(); ++j) {
                vector.addElement(participants.elementAt(j));
            }
        }
        return vector;
    }

    public Vector getFinalParticipants() {
        this.updateWorkHistory();
        Vector<VWTrkParticipant> participants = new Vector<VWTrkParticipant>();
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            VWTrkParticipant participant = work.getFinalParticipant();
            if (participant == null) continue;
            participants.addElement(participant);
        }
        if (participants.size() > 0) {
            return participants;
        }
        return null;
    }

    public boolean isActive() {
        for (int i = this.m_work.size() - 1; i >= 0; --i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (!work.isActive()) continue;
            return true;
        }
        return false;
    }

    public boolean isAltered() {
        for (int i = this.m_work.size() - 1; i >= 0; --i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (!work.isAltered()) continue;
            return true;
        }
        return false;
    }

    public boolean lockStepOccurrence() {
        boolean bLocked = true;
        for (int i = this.m_work.size() - 1; i >= 0; --i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            VWTrkParticipant participant = work.getActiveParticipant();
            if (participant == null) continue;
            bLocked &= participant.lockWork();
        }
        return bLocked;
    }

    public boolean unlockStepOccurrence(boolean bSave, boolean bDispatch) {
        boolean bUnlocked = true;
        for (int i = this.m_work.size() - 1; i >= 0; --i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            VWTrkParticipant participant = work.getActiveParticipant();
            if (participant == null) continue;
            bUnlocked &= participant.unlockWork(bSave, bDispatch);
        }
        return bUnlocked;
    }

    public int getLockedStatus() {
        int status = 0;
        for (int i = this.m_work.size() - 1; i >= 0; --i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (!work.isActive()) continue;
            status |= work.getLockedStatus();
        }
        return status;
    }

    public boolean isLockedByCurrentUserEntirely() {
        return 2 == this.getLockedStatus();
    }

    public boolean isSomeLockedByCurrentUser() {
        return (2 & this.getLockedStatus()) != 0;
    }

    public int getStepId() {
        return this.m_stepId;
    }

    int getOccurrenceId() {
        if (this.m_stepOccurrenceHistory != null && this.m_stepOccurrenceHistory.getVWStepOccurrenceHistory() != null) {
            return this.m_stepOccurrenceHistory.getVWStepOccurrenceHistory().getOccurrenceId();
        }
        return -1;
    }

    public int getOccurrenceIndex() {
        return this.m_index;
    }

    public Date getCompletionDate() {
        return this.m_stepOccurrenceHistory.getCompletionDate();
    }

    public Date getDateReceived() {
        return this.m_stepOccurrenceHistory.getDateReceived();
    }

    public String getOperationName() {
        try {
            return this.m_stepOccurrenceHistory.getVWStepOccurrenceHistory().getOperationName();
        }
        catch (VWException ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    public Date getDeadline() {
        Date stepDeadline = null;
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            Date deadline = work.getDeadline();
            if (stepDeadline == null) {
                stepDeadline = deadline;
                continue;
            }
            if (deadline != null && !deadline.before(stepDeadline)) continue;
        }
        return stepDeadline;
    }

    public int getOverdue() {
        int stepOverdue = -1;
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            int overdue = work.getOverdue();
            if (overdue <= stepOverdue) continue;
            stepOverdue = overdue;
        }
        return stepOverdue;
    }

    public int getStatus() {
        int status = this.m_stepOccurrenceHistory.getStatus();
        if (status == 12 && (status = this.getFurtherExceptionStatus(status)) == 13 && this.isActive()) {
            status = 1;
        }
        if (status == 1 && this.isActive()) {
            for (int i = 0; i < this.m_work.size(); ++i) {
                VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
                if (work == null || !work.isActive()) continue;
                int workStatus = work.getStatus();
                if (workStatus == 9) {
                    return workStatus;
                }
                if (workStatus != 10) continue;
                status = workStatus;
            }
        }
        return status;
    }

    public ImageIcon getStatusIcon() {
        return VWImageLoader.createStatusIcon(this.getStatus());
    }

    VWFieldDefinition getFieldDefinition(String name) {
        if (this.m_step != null) {
            return this.m_step.getFieldDefinition(name);
        }
        return null;
    }

    public void initDataFieldDisplayObjects() throws VWException {
        Vector wobCollection = this.getWorkObjectCollection();
        for (int j = 1; j < wobCollection.size(); ++j) {
            VWTrkWorkObject wob = (VWTrkWorkObject)wobCollection.elementAt(j);
            VWTrkTestDataField[] dfCollection = wob.getDataFields();
            for (int i = 0; i < dfCollection.length; ++i) {
                VWTrkTestDataField vwDataField = dfCollection[i];
                try {
                    if (vwDataField.getIsSystemField()) continue;
                    VWTrkDataField dataField = this.find(vwDataField.getName());
                    if (dataField != null) {
                        dataField.collateDataField(vwDataField);
                        continue;
                    }
                    dataField = new VWTrkDataField(vwDataField);
                    switch (vwDataField.getFieldType()) {
                        case 1: 
                        case 2: 
                        case 4: 
                        case 8: 
                        case 16: 
                        case 128: {
                            this.m_dataFieldObjects.addElement(dataField);
                            break;
                        }
                        case 32: {
                            this.m_attachments.addElement(dataField);
                            break;
                        }
                        case 64: {
                            this.m_workflowGroups.addElement(dataField);
                        }
                    }
                    continue;
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
        }
    }

    public void updateDataFieldDisplayObjects() {
        Vector wobCollection = this.getWorkObjectCollection();
        for (int i = 0; i < this.m_dataFieldObjects.size(); ++i) {
            ((VWTrkDataField)this.m_dataFieldObjects.elementAt(i)).updateDataFields(wobCollection);
        }
    }

    public VWTrkWorkObject getRendezvousWorkObject() {
        return this.m_rendezvousWO;
    }

    public void setRendezvousWorkObject(VWTrkWorkObject workObject) {
        this.m_rendezvousWO = workObject;
    }

    protected VWTrkDataField find(String name) {
        VWTrkDataField dataField;
        int i;
        for (i = 0; i < this.m_dataFieldObjects.size(); ++i) {
            dataField = (VWTrkDataField)this.m_dataFieldObjects.elementAt(i);
            if (VWStringUtils.compare(dataField.getName(), name) != 0) continue;
            return dataField;
        }
        for (i = 0; i < this.m_attachments.size(); ++i) {
            dataField = (VWTrkDataField)this.m_attachments.elementAt(i);
            if (VWStringUtils.compare(dataField.getName(), name) != 0) continue;
            return dataField;
        }
        for (i = 0; i < this.m_workflowGroups.size(); ++i) {
            dataField = (VWTrkDataField)this.m_workflowGroups.elementAt(i);
            if (VWStringUtils.compare(dataField.getName(), name) != 0) continue;
            return dataField;
        }
        return null;
    }

    public Vector getParticipantHistory() {
        this.updateWorkHistory();
        Vector history = new Vector();
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (work == null) continue;
            Vector workHistory = work.getParticipantHistory();
            for (int j = 0; j < workHistory.size(); ++j) {
                history.addElement(workHistory.elementAt(j));
            }
        }
        return history;
    }

    public Vector getActiveParticipants() {
        if (!this.isActive()) {
            return null;
        }
        Vector<VWTrkParticipant> collection = new Vector<VWTrkParticipant>();
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            VWTrkParticipant participant = work.getActiveParticipant();
            if (participant == null) continue;
            collection.addElement(participant);
        }
        if (collection.size() > 0) {
            return collection;
        }
        return null;
    }

    public boolean isDataEditable() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return lockStatus == 2;
        }
        return false;
    }

    public boolean isLockedByOther() {
        if (this.isActive()) {
            int lockStatus = this.getLockedStatus();
            return (lockStatus & 0xC) != 0;
        }
        return false;
    }

    public ImageIcon getLockedStatusIcon() {
        int icon = 0;
        if (this.isActive()) {
            boolean bLockedByOther;
            int lockedStatus = this.getLockedStatus();
            boolean bUnlocked = (lockedStatus & 1) != 0;
            boolean bLockedByTracker = (lockedStatus & 2) != 0;
            boolean bl = bLockedByOther = (lockedStatus & 0xC) != 0;
            if (bUnlocked) {
                icon = 1;
            }
            if (bLockedByTracker) {
                icon += 2;
            }
            if (bLockedByOther) {
                icon += 4;
            }
        }
        return VWImageLoader.createLockIcon(icon);
    }

    void removeAllWorkObjects(boolean bSave) {
        Object obj;
        int i;
        if (this.m_rendezvousWO != null) {
            this.m_rendezvousWO.removeReferences();
            this.m_rendezvousWO = null;
        }
        if (this.m_work == null || this.m_work.size() == 0) {
            return;
        }
        for (i = 0; i < this.m_work.size(); ++i) {
            VWTrkParticipant participant;
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (work == null || (participant = work.getActiveParticipant()) == null) continue;
            participant.removeWorkObject(bSave);
        }
        if (this.m_dataFieldObjects != null) {
            for (i = 0; i < this.m_dataFieldObjects.size(); ++i) {
                obj = this.m_dataFieldObjects.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_dataFieldObjects.removeAllElements();
            this.m_dataFieldObjects = null;
        }
        if (this.m_attachments != null) {
            for (i = 0; i < this.m_attachments.size(); ++i) {
                obj = this.m_attachments.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_attachments.removeAllElements();
            this.m_attachments = null;
        }
        if (this.m_workflowGroups != null) {
            for (i = 0; i < this.m_workflowGroups.size(); ++i) {
                obj = this.m_workflowGroups.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_workflowGroups.removeAllElements();
            this.m_workflowGroups = null;
        }
    }

    void save() throws VWException {
        if (this.m_work == null || this.m_work.size() == 0) {
            return;
        }
        VWException exception = null;
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkParticipant participant;
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (work == null || (participant = work.getActiveParticipant()) == null) continue;
            try {
                participant.save();
                continue;
            }
            catch (VWException ex) {
                VWDebug.logException(ex);
                if (exception != null) continue;
                exception = ex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    void disgardChanges() {
        if (this.m_work == null || this.m_work.size() == 0) {
            return;
        }
        for (int i = 0; i < this.m_work.size(); ++i) {
            VWTrkParticipant participant;
            VWTrkWork work = (VWTrkWork)this.m_work.elementAt(i);
            if (work == null || (participant = work.getActiveParticipant()) == null) continue;
            participant.disgardChanges();
        }
    }

    public void removeReferences() {
        Object obj;
        int i;
        this.m_step = null;
        if (this.m_stepOccurrenceHistory != null) {
            this.m_stepOccurrenceHistory.removeReferences();
            this.m_stepOccurrenceHistory = null;
        }
        if (this.m_rendezvousWO != null) {
            this.m_rendezvousWO.removeReferences();
            this.m_rendezvousWO = null;
        }
        if (this.m_work != null) {
            for (i = 0; i < this.m_work.size(); ++i) {
                obj = this.m_work.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkWork)) continue;
                ((VWTrkWork)obj).removeReferences();
            }
            this.m_work.removeAllElements();
            this.m_work = null;
        }
        if (this.m_dataFieldObjects != null) {
            for (i = 0; i < this.m_dataFieldObjects.size(); ++i) {
                obj = this.m_dataFieldObjects.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_dataFieldObjects.removeAllElements();
            this.m_dataFieldObjects = null;
        }
        if (this.m_attachments != null) {
            for (i = 0; i < this.m_attachments.size(); ++i) {
                obj = this.m_attachments.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_attachments.removeAllElements();
            this.m_attachments = null;
        }
        if (this.m_workflowGroups != null) {
            for (i = 0; i < this.m_workflowGroups.size(); ++i) {
                obj = this.m_workflowGroups.elementAt(i);
                if (obj == null || !(obj instanceof VWTrkDataField)) continue;
                ((VWTrkDataField)obj).removeReferences();
            }
            this.m_workflowGroups.removeAllElements();
            this.m_workflowGroups = null;
        }
    }

    private int getFurtherExceptionStatus(int status) {
        if (status != 12) {
            return status;
        }
        VWTrkDataModel dataModel = this.getDataModel();
        if (dataModel == null) {
            return status;
        }
        VWProcess process = dataModel.getProcess();
        if (process == null) {
            return status;
        }
        int stepId = this.getStepId();
        int mapId = this.getStep().getMapId();
        Vector WOVector = dataModel.getExceptionWO(mapId, stepId);
        if (WOVector == null || WOVector.size() == 0) {
            status = 13;
        }
        return status;
    }
}

